<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_About_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-about-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('About Us Section', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'About', 'About Us', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-section';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('About Us', 'bizmaster-core'),
            ]
        );

		$this->add_control(
            'shape_image', [
                'label' => esc_html__('Shape Icon', 'bizmaster-core'),
                'type' => Controls_Manager::ICONS,
                'show_label' => false,
                'description' => esc_html__('Upload Icon', 'bizmaster-core'),
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Achieve Your a of Business', 'bizmaster-core'),
            ]
        );

		$this->add_control(
            'content',
            [
                'label' => esc_html__('Content', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Use receiving aco growin number of currencies and get paid like design receiving aco grow.', 'bizmaster-core'),
            ]
        );

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_title',
			[
				'label' => esc_html__('List Title', 'bizmaster-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Strategic Solutions Pro', 'bizmaster-core'),
			]
		);

		$repeater->add_control(
            'list_content',
            [
                'label' => esc_html__('List Content', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('There are many variati of passages of engineer’s available. The majority have suffered alteration in engineer’s available.', 'bizmaster-core'),
            ]
        );

        $this->add_control('list_items', [
            'label' => esc_html__('List Items', 'bizmaster-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls()
		]);

        $this->add_control(
			'btn_text',
			[
				'label' => esc_html__('Button Text', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Read More', 'bizmaster-core'),
			]
		);

		$this->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'bizmaster-core' ),
				'type' => Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false
				],
				'label_block' => true
			]
		);

		$this->add_control(
            'image2', [
                'label' => esc_html__('Upload Left Side Shape Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('upload left side shape image', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'image', [
                'label' => esc_html__('Right Side Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('upload right side image', 'bizmaster-core'),
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'client_settings_section',
            [
                'label' => esc_html__('Client Logos', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
            'client_img', [
                'label' => esc_html__('Logo Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src()
				],
				'description' => esc_html__('upload client logo image', 'bizmaster-core')
			]
		);

        $this->add_control('client_items', [
            'label' => esc_html__('Client Logo', 'bizmaster-core'),
			'show_label' => false,
			'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls()
		]);

        $this->end_controls_section();

		$this->start_controls_section(
            'styling_section',
            [
				'label' => esc_html__('Styling Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control('subtitle_icon_color', [
            'label' => esc_html__('Sub Title Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-content-wrap .sub-title svg" => "fill: {{VALUE}}; color: {{VALUE}}"
            ]
        ]);

		$this->add_control('subtitle_color', [
			'label' => esc_html__('Sub Title Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .about-content-wrap .sub-title" => "color: {{VALUE}}"
			]
		]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Sub Title Typography', 'bizmaster-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Sub Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .about-content-wrap .sub-title"
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-content-wrap .sec-title" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .about-content-wrap .sec-title"
        ]);

        $this->add_control('content_color', [
            'label' => esc_html__('Content Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-content-wrap .sec-text" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Content Typography', 'bizmaster-core'),
            'name' => 'content_typography',
            'description' => esc_html__('Content Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .about-content-wrap .sec-text"
        ]);

        $this->add_control('list_icon_color', [
            'label' => esc_html__('List Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .achive-about_icon svg path" => "fill: {{VALUE}}; color: {{VALUE}}"
            ]
        ]);

		$this->add_control('list_title_color', [
            'label' => esc_html__('List Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .achive-about .box-title" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('List Title Typography', 'bizmaster-core'),
            'name' => 'list_title_typography',
            'description' => esc_html__('List Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .achive-about .box-title"
        ]);

		$this->add_control('list_content_color', [
            'label' => esc_html__('List Content Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .achive-about .achive-about_text" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('List Content Typography', 'bizmaster-core'),
            'name' => 'list_content_typography',
            'description' => esc_html__('List Content Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .achive-about .achive-about_text"
        ]);

		$this->add_control('btn_bg_color', [
            'label' => esc_html__('Button BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-content-wrap .global-btn" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('btn_bg_hover_color', [
            'label' => esc_html__('Button BG Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-content-wrap .global-btn:after" => "background: {{VALUE}}",
				"{{WRAPPER}} .about-content-wrap .global-btn:before" => "background: {{VALUE}}"
            ]
        ]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$rand_numb = rand(333, 999999999);
		$list_items = $settings['list_items'];
		$client_items = $settings['client_items'];
		?>
		<div class="about-area-1 position-relative space-top">
			<?php if($settings['image']['url']) : ?>
				<div class="about1-shape-img1">
					<img class="about1-shape-img-1" src="<?php echo $settings['image']['url']; ?>">
                </div>
			<?php endif; ?>
			<?php if($settings['image2']['url']) : ?>
				<div class="about1-shape-img2">
					<img class="about1-shape-img-2" src="<?php echo $settings['image2']['url']; ?>">
				</div>
			<?php endif; ?>

			<div class="container">
                <div class="row gx-60 align-items-center">
                    <div class="col-xl-6">
                        <div class="about-content-wrap me-xl-5">
                            <div class="title-area mb-20">
								<?php if(!empty($settings['subtitle'])) : ?>
									<span class="sub-title">
										<?php 
											Icons_Manager::render_icon($settings['shape_image'], ['aria-hidden' => 'true']);
											echo $settings['subtitle']; 
										?>  
									</span>
								<?php endif; ?>
								<?php if(!empty($settings['title'])) : ?><h2 class="sec-title"><?php echo $settings['title']; ?></h2><?php endif; ?>
								<?php if(!empty($settings['content'])) : ?><p class="sec-text mb-35"><?php echo $settings['content']; ?></p><?php endif; ?>
                            </div>
                            <?php foreach ($list_items as $item): ?>
                                <div class="achive-about">
                                    <div class="achive-about_content">
                                        <div class="achive-about_icon">
                                            <i class="fas fa-check"></i>
                                        </div>
                                        <div class="media-body">
                                            <h3 class="box-title"><?php echo $item['list_title']; ?></h3>
                                            <p class="achive-about_text"><?php echo $item['list_content']; ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
							<?php if(!empty($settings['btn_text'])) : ?>
								<?php
									if ( ! empty( $settings['btn_url']['url'] ) ) {
										$this->add_link_attributes( 'btn_url', $settings['btn_url'] );
									}
								?>
								<div class="btn-wrap mt-20">
									<a <?php $this->print_render_attribute_string( 'btn_url' ); ?> class="global-btn mt-xl-0 mt-20"><?php echo $settings['btn_text']; ?> <i class="fas fa-arrow-right ms-2"></i></a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="client-bg-area-2 space-bottom z-indez-3">
			<div class="client-area-2">
				<div class="about-client-logos" id="about-client-logos-<?php echo esc_attr($rand_numb); ?>" data-slide-show="4" data-xxl-slide-show="4" data-lg-slide-show="3" data-md-slide-show="3" data-sm-slide-show="2">
					<?php foreach ($client_items as $c_item): ?>
						<div class="col-lg-auto">
							<div class="client-logo">
								<img src="<?php echo $c_item['client_img']['url']; ?>">
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_About_Widget());
