<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Contact_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-contact-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Contact', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'icon', [
				'label' => esc_html__('Icon', 'bizmaster-core'),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-arrow-right',
					'library' => 'solid'
				]
			]
		);

		$repeater->add_control(
			'title', [
				'label' => esc_html__('Title', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Phone', 'bizmaster-core')
			]
		);

		$repeater->add_control(
			'content', [
				'label' => esc_html__('Content', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('(629) 555-0129', 'bizmaster-core')
			]
		);

		$this->add_control('contact_items', [
			'label' => esc_html__('Contact Items', 'bizmaster-core'),
			'type' => Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls()
		]);

		$this->end_controls_section();

		/*  tab styling tabs start */
		$this->start_controls_section(
			'style_settings_section',
			[
				'label' => esc_html__('Style Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control('bg_color', [
            'label' => esc_html__('Background Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .contact-page-wrap" => "background-color: {{VALUE}} !important;"
            ]
        ]);

		$this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .contact-page-wrap .contact-info_details .contact-info_title" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Title Typography', 'bizmaster-core'),
			'name' => 'title_typography',
			'description' => esc_html__('Title Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .contact-page-wrap .contact-info_details .contact-info_title"
		]);

		$this->add_control('career_card_content_color', [
            'label' => esc_html__('Content Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .contact-page-wrap .contact-info_details .contact-info_text" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Content Typography', 'bizmaster-core'),
			'name' => 'career_card_content_typography',
			'description' => esc_html__('Content Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .contact-page-wrap .contact-info_details .contact-info_text"
		]);

		$this->add_control('icon_bg_color', [
            'label' => esc_html__('Icon BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .contact-page-wrap .contact-info .contact-info_icon" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('icon_color', [
            'label' => esc_html__('Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .contact-page-wrap .contact-info .contact-info_icon svg" => "color: {{VALUE}}; fill: {{VALUE}}"
            ]
        ]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
		$settings = $this->get_settings_for_display();
        $contact_items = $settings['contact_items'];
		?>
		<div class="contact-area">
            <div class="container">
                <div class="contact-page-wrap">
                    <div class="row gy-40 align-items-center">
                        <?php foreach ($contact_items as $item): ?>
                            <div class="col-lg-4 col-md-6">
                                <div class="contact-info">
                                    <div class="contact-info_icon">
										<?php Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
									</div>
									<div class="contact-info_details">
										<h6 class="contact-info_title"><?php echo $item['title']; ?></h6>
										<p class="contact-info_text"><?php echo $item['content']; ?></p>
									</div>
								</div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Contact_Widget());
