<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Team_member_Info_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-team-member-info-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Team Member Info', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('name', [
            'label' => esc_html__('Name', 'bizmaster-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Fahad Bhuiyan', 'bizmaster-core'),
        ]);

        $this->add_control('designation', [
            'label' => esc_html__('Designation', 'bizmaster-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Manager', 'bizmaster-core'),
        ]);

        $this->add_control('content', [
            'label' => esc_html__('Content', 'bizmaster-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => esc_html__('This category focuses on the design construction of buildings and the This a category focuses on the design and construction of buildings', 'bizmaster-core'),
        ]);

        $this->add_control('address', [
            'label' => esc_html__('Address', 'bizmaster-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => 'Burmsille Street, MN 55337, <br> United States',
        ]);

        $this->add_control('phone', [
            'label' => esc_html__('Phone', 'bizmaster-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => '+(1) 123 456 7890 <br> +(1) 098 765 4321',
        ]);

        $this->add_control('email', [
            'label' => esc_html__('Email', 'bizmaster-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => 'info@fixturbo.com <br> info.example@fixturbo.com',
        ]);

        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
            's_icon',
            [
                'label' => esc_html__('Icon', 'bizmaster-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon.', 'bizmaster-core'),
                'default' => [
                    'value' => 'fas fa-phone-alt',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            's_url', [
                'label' => esc_html__('Social Url', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'bizmaster-core'),
            ]
        );

        $this->add_control('social_items', [
            'label' => esc_html__('Social Item', 'bizmaster-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
			'prevent_empty' => false
        ]);

        $this->end_controls_section();

		$this->start_controls_section(
            'team_member_info_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-details-wrap h4.team-details-wrap-title" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-details-wrap h4.team-details-wrap-title"
        ]);

		$this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-details-wrap h6.team-details-wrap-desig" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'bizmaster-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-details-wrap h6.team-details-wrap-desig"
        ]);

		$this->add_control('member_content_color', [
            'label' => esc_html__('Member Content Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-details-wrap .team-details-wrap-text" => "color: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Member Content Typography', 'bizmaster-core'),
            'name' => 'member_content_typography',
            'description' => esc_html__('Member Content Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .team-details-wrap .team-details-wrap-text"
        ]);

		$this->add_control('member_info_icon_bg_color', [
            'label' => esc_html__('Member Info Icon BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'default' => '#EBF3EE',
			'selectors' => [
                "{{WRAPPER}} .team-details-wrap .team-details-wrap_info .icon" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('member_info_icon_color', [
            'label' => esc_html__('Member Info Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'default' => '#19352D',
			'selectors' => [
                "{{WRAPPER}} .team-details-wrap .team-details-wrap_info .icon svg" => "color: {{VALUE}}; fill: {{VALUE}};"
			]
        ]);

		$this->add_control(
			'social_icon_size',
			[
				'label' => esc_html__( 'Social Icon Size', 'bizmaster-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1
					]
				],
				'default' => [
					'size' => 16,
					'unit' => 'px'
				],
				'selectors' => [
					'{{WRAPPER}} .team-details-wrap .social-btn a' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .team-details-wrap .social-btn a svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
				]
			]
		);

        $this->add_control('social_share_icons_bg_color', [
            'label' => esc_html__('Social Share Icons BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'default' => '#EBF3EE',
            'selectors' => [
                "{{WRAPPER}} .team-details-wrap .social-btn.style4 a" => "background-color: {{VALUE}}"
            ]
        ]);

		$this->add_control('social_share_icons_hover_bg_color', [
            'label' => esc_html__('Social Share Icons Hover BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'default' => '#19352D',
            'selectors' => [
                "{{WRAPPER}} .team-details-wrap .social-btn.style4 a:hover" => "background-color: {{VALUE}}"
            ]
        ]);

        $this->add_control('social_share_icon_color', [
            'label' => esc_html__('Social Share Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'default' => '#19352D',
            'selectors' => [
                "{{WRAPPER}} .team-details-wrap .social-btn.style4 a svg" => "color: {{VALUE}}; fill: {{VALUE}};",
            ]
        ]);

		$this->add_control('social_share_icon_hover_color', [
            'label' => esc_html__('Social Share Icon Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
			'default' => '#FFFFFF',
            'selectors' => [
                "{{WRAPPER}} .team-details-wrap .social-btn.style4 a:hover svg" => "color: {{VALUE}}; fill: {{VALUE}};",
            ]
        ]);

        $this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); 
        $social_items = $settings['social_items'];
        ?>

        <div class="team-details-wrap">
            <?php if($settings['name']) : ?>
                <h4 class="team-details-wrap-title"><?php echo $settings['name']; ?></h4>
            <?php endif; ?>
            <?php if($settings['designation']) : ?>
                <h6 class="team-details-wrap-desig"><?php echo $settings['designation']; ?></h6>
            <?php endif; ?>
            <?php if($settings['content']) : ?>
                <p class="team-details-wrap-text mb-30"><?php echo $settings['content']; ?></p>
            <?php endif; ?>
            <div class="team-details-wrap_info">
                <span class="icon"><i class="fas fa-map-marker-alt"></i></span>
                <p><?php echo $settings['address']; ?></p>
            </div>
            <div class="team-details-wrap_info">
                <span class="icon"><i class="fas fa-phone-alt"></i></span>
                <p><?php echo $settings['phone']; ?></p>
            </div>
            <div class="team-details-wrap_info">
                <span class="icon"><i class="fas fa-envelope"></i></span>
                <p><?php echo $settings['email']; ?></p>
            </div>
            <div class="social-btn style4 mt-35">
                <?php foreach ($social_items as $s_item) : ?>
                    <a href="<?php echo $s_item['s_url']; ?>" tabindex="-1">
                        <?php
                            Icons_Manager::render_icon($s_item['s_icon'], ['aria-hidden' => 'true']);
                        ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Team_member_Info_Widget());