<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Work_Process_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-theme-work-process-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Working Process', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Heading', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-heading';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'process_image', [
                'label' => esc_html__('Process Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Process Image', 'bizmaster-core'),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('Number', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('1', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Technical Operation', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Growth Acceler', 'bizmaster-core'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Sub Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .process-card .process-card-text" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Sub Title Typography', 'bizmaster-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Sub Title typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .process-card .process-card-text"
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .process-card .process-card-title" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'bizmaster-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .process-card .process-card-title"
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <!-- my -->
        <div class="process-card-wrap">
            <div class="process-card">
                <div class="process-card_wrapp">
                    <div class="process-card-icon">
                    <?php if (!empty($settings['process_image'])) : ?>
                        <img src="<?php echo $settings['process_image']['url']; ?>" alt="img">
                    <?php endif; ?>
                    </div>
                    <h3 class="process-card_number"><?php echo $settings['number']; ?></h3>
                </div>
                <div class="process-card_content">
                    <span class="process-card-text"><?php echo $settings['subtitle']; ?></span>
                    <h4 class="process-card-title"> <?php echo $settings['title']; ?></h4>
                </div>
            </div>
        </div>
        <!-- my -->
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Work_Process_Widget());